package com.introtoandroid.simplemasterdetailflow;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;


public class TopicDetailActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_topic_detail);

        assert getSupportActionBar() != null;
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        if (savedInstanceState == null) {
            Bundle arguments = new Bundle();
            arguments.putString(TopicDetailFragment.ARG_ITEM_ID,
                    getIntent().getStringExtra(TopicDetailFragment.ARG_ITEM_ID));
            TopicDetailFragment fragment = new TopicDetailFragment();
            fragment.setArguments(arguments);
            getSupportFragmentManager().beginTransaction()
                    .add(R.id.topic_detail_container, fragment)
                    .commit();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == android.R.id.home) {
            // To ID repreznetuje przyciski Strona główna lub W górę. 
            // W przypadku tej aktywności prezentowany jest przycisk W górę.
            // Więcej informacji na ten temat można znaleźć w witrynie dla 
            // programistów, w sekcji poświęconej projektowaniu aplikacji na Androida:
            //
            // http://developer.android.com/design/patterns/navigation.html#up-vs-back
            //
            supportNavigateUpTo(new Intent(this, TopicListActivity.class));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
